/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.JCScrollbar;
import jclass.bwt.ScrolledWindowConverter;
import jclass.bwt.Viewport;

public class JCScrolledWindow
extends JCContainer
implements KeyListener,
JCAdjustmentListener {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NONE = 2;
    public static final int DISPLAY_VERTICAL_ONLY = 3;
    public static final int DISPLAY_HORIZONTAL_ONLY = 4;
    int sb_display = 0;
    int sb_offset;
    private JCScrollbar vert_sb = new JCScrollbar(1);
    private JCScrollbar horiz_sb = new JCScrollbar(0);
    int keystroke;
    private static final String base = "scrolledwindow";
    private static int nameCounter;
    protected Component viewport;
    Rectangle rect = new Rectangle();

    public JCScrolledWindow() {
        this(null, null);
    }

    public JCScrolledWindow(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.viewport = new Viewport();
        if (this.getClass().getName().equals("jclass.bwt.JCScrolledWindow")) {
            this.getParameters(applet);
        }
        this.addInternal(this.vert_sb);
        this.vert_sb.addAdjustmentListener(this);
        this.addInternal(this.horiz_sb);
        this.horiz_sb.addAdjustmentListener(this);
    }

    protected void getParameters() {
        super.getParameters();
        ScrolledWindowConverter.getParams(this);
    }

    public int getScrollbarDisplay() {
        return this.sb_display;
    }

    public void setScrollbarDisplay(int n) {
        ScrolledWindowConverter.checkDisplay(n);
        this.sb_display = n;
        this.layout();
    }

    public int getScrollbarOffset() {
        return this.sb_offset;
    }

    public void setScrollbarOffset(int n) {
        this.sb_offset = n;
        this.layout();
    }

    public Component getViewport() {
        return this.viewport;
    }

    int sb_size() {
        if (this.sb_display == 1) {
            return 16 + this.sb_offset;
        }
        return 0;
    }

    protected int preferredWidth() {
        if (this.viewport != null) {
            return this.viewport.preferredSize().width + this.sb_size();
        }
        return 100;
    }

    protected int preferredHeight() {
        if (this.viewport != null) {
            return this.viewport.preferredSize().height + this.sb_size();
        }
        return 100;
    }

    protected int getViewportWidth() {
        return this.viewport.preferredSize().width;
    }

    protected int getViewportHeight() {
        return this.viewport.preferredSize().height;
    }

    public Component add(Component component) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component);
            if (!(component instanceof Container)) {
                component.addKeyListener(this);
            }
        }
        return component;
    }

    protected void addInternal(Component component) {
        if (component.getParent() != this) {
            super.add(component);
        }
    }

    public void addNotify() {
        this.addInternal(this.viewport);
        super.addNotify();
    }

    public JCScrollbar getVertScrollbar() {
        return this.vert_sb;
    }

    public JCScrollbar getHorizScrollbar() {
        return this.horiz_sb;
    }

    protected void setHorizScrollbarValues() {
    }

    protected void setHorizScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.horiz_sb.setValues(n, n2, n3, n4);
        this.horiz_sb.setBlockIncrement(n2);
        this.horiz_sb.setUnitIncrement(10);
        this.setHorizScrollbarValues();
    }

    protected void setVertScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.vert_sb.setValues(n, n2, n3, n4);
        this.vert_sb.setBlockIncrement(n2);
        this.vert_sb.setUnitIncrement(10);
        this.setVertScrollbarValues();
    }

    protected void setVertScrollbarValues() {
    }

    protected int reshapeHeader(int n, int n2, int n3) {
        return 0;
    }

    protected int headerHeight() {
        return 0;
    }

    protected void reshapeViewport(int n, int n2, int n3, int n4) {
        this.viewport.reshape(n, n2, n3, n4);
    }

    public synchronized void layout() {
        Serializable serializable;
        int n;
        boolean bl;
        boolean bl2;
        if (this.getPeer() == null) {
            return;
        }
        int n2 = this.size().width - this.insets().left - this.insets().right;
        int n3 = this.size().height - this.insets().top - this.insets().bottom;
        int n4 = n3 - this.headerHeight();
        int n5 = n2;
        int n6 = this.getViewportWidth();
        int n7 = this.getViewportHeight();
        if (this.sb_display == 2) {
            bl2 = false;
            bl = false;
        } else if (this.sb_display == 1) {
            bl2 = true;
            bl = true;
        } else if (n4 >= n7 && n5 >= n6 && this.sb_display == 0) {
            n5 = n2;
            n4 = n3;
            bl2 = false;
            bl = false;
        } else {
            bl = this.sb_display != 4;
            boolean bl3 = bl2 = this.sb_display != 3;
            if (n7 <= n4 && this.sb_display != 3) {
                n5 = n2;
                bl = false;
            } else {
                n5 = n2 - (16 + this.sb_offset);
            }
            if (n6 <= n5 && this.sb_display != 4) {
                n4 = n3;
                bl2 = false;
            }
        }
        n4 = bl2 ? n3 - (16 + this.sb_offset) : n3;
        n5 = bl ? n2 - (16 + this.sb_offset) : n2;
        int n8 = 0;
        int n9 = 0;
        if (bl2) {
            n8 = !bl ? n2 : n5;
        }
        if (bl) {
            n9 = !bl2 ? n3 : n4;
        }
        int n10 = this.insets().left;
        int n11 = this.insets().top;
        int n12 = this.insets().left;
        int n13 = bl2 ? this.size().height - this.insets().bottom - 16 : this.size().height;
        int n14 = bl ? this.size().width - this.insets().right - 16 : n2;
        int n15 = this.insets().top;
        int n16 = this.reshapeHeader(n10, n11, n5);
        n11 += n16;
        n15 += n16;
        n9 -= n16;
        int n17 = n = this.vert_sb.getValue();
        if ((n = Math.max(0, Math.min(n, n7 - (n4 -= n16)))) != n17) {
            this.scrollVertical(null, n);
        }
        int n18 = n7;
        int n19 = n4;
        if (this.viewport instanceof JCComponent) {
            serializable = (JCComponent)this.viewport;
            n16 = 2 * serializable.shadow + serializable.insets.top + serializable.insets.bottom;
            n19 -= n16;
            n18 -= n16;
        }
        this.setVertScrollbarValues(n, n19, 0, n18);
        n17 = n = this.horiz_sb.getValue();
        n = Math.max(0, Math.min(n, n6 - n5));
        if (n != n17) {
            this.scrollHorizontal(null, n);
        }
        n18 = n6;
        n19 = n5;
        if (this.viewport instanceof JCComponent) {
            serializable = (JCComponent)this.viewport;
            int n20 = 2 * serializable.shadow + serializable.insets.left + serializable.insets.right;
            n19 -= n20;
            n18 -= n20;
        }
        this.setHorizScrollbarValues(n, n19, 0, n18);
        this.reshapeViewport(n10, n11, n5, n4);
        serializable = this.viewport.location();
        Dimension dimension = this.viewport.size();
        if (bl) {
            this.vert_sb.reshape(((Point)serializable).x + dimension.width + this.sb_offset, ((Point)serializable).y, 16, n9);
        }
        this.vert_sb.show(bl);
        if (bl2) {
            this.horiz_sb.reshape(((Point)serializable).x, ((Point)serializable).y + dimension.height + this.sb_offset, n8, 16);
        }
        this.horiz_sb.show(bl2);
    }

    protected void scrollHorizontal(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getHorizOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setHorizOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.width) {
            component.repaint();
            return;
        }
        int n4 = this.rect.width - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            jCComponent.copyArea(graphics, this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
            jCComponent.repaint(graphics, this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
        } else {
            graphics.copyArea(this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
            component.repaint(this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getVertOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setVertOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.height) {
            component.repaint();
            return;
        }
        int n4 = this.rect.height - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            jCComponent.copyArea(graphics, this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
            jCComponent.repaint(graphics, this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
        } else {
            graphics.copyArea(this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
            component.repaint(this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollVertical(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollVertical((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    protected void scrollHorizontal(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollHorizontal(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollHorizontal((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    public void scrollVertical(int n) {
        this.vert_sb.setValue(n);
        this.scrollVertical(null, this.vert_sb.getValue());
    }

    public void scrollHorizontal(int n) {
        this.horiz_sb.setValue(n);
        this.scrollHorizontal(null, this.horiz_sb.getValue());
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                this.keystroke = 1002;
                this.scrollVertical(this.vert_sb.getValue() - this.vert_sb.getBlockIncrement());
                break;
            }
            case 34: {
                this.keystroke = 1003;
                this.scrollVertical(this.vert_sb.getValue() + this.vert_sb.getBlockIncrement());
                break;
            }
            case 36: {
                this.keystroke = 1000;
                this.scrollVertical(0);
                break;
            }
            case 35: {
                this.keystroke = 1001;
                this.scrollVertical(this.vert_sb.getMaximum());
                break;
            }
            case 37: {
                this.keystroke = 1006;
                this.scrollHorizontal(this.horiz_sb.getValue() - this.horiz_sb.getUnitIncrement());
                break;
            }
            case 39: {
                this.keystroke = 1007;
                this.scrollHorizontal(this.horiz_sb.getValue() + this.horiz_sb.getUnitIncrement());
                break;
            }
        }
        this.keystroke = 0;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        if (jCAdjustmentEvent.getSource() == this.vert_sb) {
            this.scrollVertical(jCAdjustmentEvent, this.vert_sb.getValue());
            return;
        }
        if (jCAdjustmentEvent.getSource() == this.horiz_sb) {
            this.scrollHorizontal(jCAdjustmentEvent, this.horiz_sb.getValue());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

